library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.NUMERIC_STD.ALL;

entity find_max is  --find the muximum energy from 7 muximum values
    Port ( clk : in STD_LOGIC;
           start : in STD_LOGIC;
           --t_finish : in STD_LOGIC;
	   val_in : in STD_LOGIC_VECTOR (31 downto 0);
          -- adder_enable : in STD_LOGIC;
           --fifo_wr_en : out STD_LOGIC;
	   val_out : out STD_LOGIC_VECTOR (31 downto 0);
	   angle_ind_out : out STD_LOGIC_VECTOR(7 downto 0);
	   finished : out STD_LOGIC);
end find_max;

architecture behavior of find_max is
  type STATES is (IDLE,REVIEW);
  type VALINDS is array (0 to 2) of integer;
  signal state : STATES := IDLE;
  signal current_max : STD_LOGIC_VECTOR (31 downto 0); --change if decimating squared signal


begin
  process (clk) 
    variable i : integer := 0;
	
  begin
    if (rising_edge(clk)) then
        case state is
          -- Waiting for start
          when IDLE =>

		if (start = '1') then
		   state <= REVIEW;	
		end if;           
		  when REVIEW =>
		      if (val_in > current_max) then
		          current_max<=val_in;
		          angle_ind_out<= std_logic_vector(to_unsigned(i, 8));
		      end if;
		      if (i < 6) then
		          i:=i+1;
		      else
		      finished <= '1';
		      state <= IDLE;
		      end if;
        end case;
    end if;
  end process;
end behavior;

